#include "stdafx.h"
#include "toupcamdemomfc.h"
#include "toupcamdemomfcDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CtoupcamdemomfcDlg::CtoupcamdemomfcDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CtoupcamdemomfcDlg::IDD, pParent), m_hToupcam(NULL), m_pImageData(NULL)
{
	memset(&m_header, 0, sizeof(m_header));
	m_header.biSize = sizeof(m_header);
	m_header.biPlanes = 1;
	m_header.biBitCount = 24;
}

void CtoupcamdemomfcDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CtoupcamdemomfcDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON1, &CtoupcamdemomfcDlg::OnBnClickedButton1)
	ON_CBN_SELCHANGE(IDC_COMBO1, &CtoupcamdemomfcDlg::OnCbnSelchangeCombo1)
	ON_MESSAGE(MSG_CAMEVENT, &CtoupcamdemomfcDlg::OnMsgCamevent)
	ON_WM_DESTROY()
END_MESSAGE_MAP()

BOOL CtoupcamdemomfcDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	return TRUE;
}

void CtoupcamdemomfcDlg::OnBnClickedButton1()
{
	if (m_hToupcam)
		return;

	m_hToupcam = Toupcam_Open(NULL);
	if (NULL == m_hToupcam)
	{
		AfxMessageBox(_T("No Device"));
		return;
	}

	CComboBox* pCombox = (CComboBox*)GetDlgItem(IDC_COMBO1);
	pCombox->ResetContent();
	int n = (int)Toupcam_get_ResolutionNumber(m_hToupcam);
	if (n > 0)
	{
		TCHAR txt[128];
		int nWidth, nHeight;
		for (int i = 0; i < n; ++i)
		{
			Toupcam_get_Resolution(m_hToupcam, i, &nWidth, &nHeight);
			_stprintf(txt, _T("%d * %d"), nWidth, nHeight);
			pCombox->AddString(txt);
		}

		unsigned nCur = 0;
		Toupcam_get_eSize(m_hToupcam, &nCur);
		pCombox->SetCurSel(nCur);
	}
	
	StartDevice();
}

void CtoupcamdemomfcDlg::StartDevice()
{
	int nWidth = 0, nHeight = 0;
	HRESULT hr = Toupcam_get_Size(m_hToupcam, &nWidth, &nHeight);
	if (FAILED(hr))
		return;
	m_header.biWidth = nWidth;
	m_header.biHeight = nHeight;
	m_header.biSizeImage = TDIBWIDTHBYTES(nWidth * 24) * nHeight;
	if (m_pImageData)
	{
		free(m_pImageData);
		m_pImageData = NULL;
	}
	m_pImageData = malloc(m_header.biSizeImage);

	Toupcam_StartPullModeWithWndMsg(m_hToupcam, m_hWnd, MSG_CAMEVENT);

	OnEventExpo();
}

void CtoupcamdemomfcDlg::OnCbnSelchangeCombo1()
{
	if (NULL == m_hToupcam)
		return;

	CComboBox* pCombox = (CComboBox*)GetDlgItem(IDC_COMBO1);
	int nSel = pCombox->GetCurSel();
	if (nSel < 0)
		return;

	unsigned nResolutionIndex = 0;
	HRESULT hr = Toupcam_get_eSize(m_hToupcam, &nResolutionIndex);
	if (FAILED(hr))
		return;

	if (nResolutionIndex != nSel)
	{
		hr = Toupcam_Stop(m_hToupcam);
		if (FAILED(hr))
			return;

		Toupcam_put_eSize(m_hToupcam, nSel);

		StartDevice();
	}
}

LRESULT CtoupcamdemomfcDlg::OnMsgCamevent(WPARAM wp, LPARAM /*lp*/)
{
	switch (wp)
	{
	case TOUPCAM_EVENT_ERROR:
		OnEventError();
		break;
	case TOUPCAM_EVENT_IMAGE:
		OnEventImage();
		break;
	case TOUPCAM_EVENT_EXPOSURE:
		OnEventExpo();
		break;
	default:
		break;
	}
	return 0;
}

void CtoupcamdemomfcDlg::OnEventError()
{
	if (m_hToupcam)
	{
		Toupcam_Close(m_hToupcam);
		m_hToupcam = NULL;
	}
	AfxMessageBox(_T("Error"));
}

void CtoupcamdemomfcDlg::OnEventExpo()
{
	unsigned nTime = 0;
	Toupcam_get_ExpoTime(m_hToupcam, &nTime);
	SetDlgItemInt(IDC_STATIC1, nTime, FALSE);
}

void CtoupcamdemomfcDlg::OnEventImage()
{
	HRESULT hr = Toupcam_PullImage(m_hToupcam, m_pImageData, 24, NULL, NULL);
	if (SUCCEEDED(hr))
	{
		CClientDC dc(this);
		CRect rc, rcStartButton;
		GetClientRect(&rc);
		GetDlgItem(IDC_BUTTON1)->GetWindowRect(&rcStartButton);
		ScreenToClient(&rcStartButton);
		rc.left = rcStartButton.right + 4;
		rc.top += 4;
		rc.bottom -= 4;
		rc.right -= 4;

		int m = dc.SetStretchBltMode(COLORONCOLOR);
		StretchDIBits(dc, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, 0, 0, m_header.biWidth, m_header.biHeight, m_pImageData, (BITMAPINFO*)&m_header, DIB_RGB_COLORS, SRCCOPY);
		dc.SetStretchBltMode(m);
	}
}

void CtoupcamdemomfcDlg::OnDestroy()
{
	if (m_hToupcam)
	{
		Toupcam_Close(m_hToupcam);
		m_hToupcam = NULL;
	}
	if (m_pImageData)
	{
		free(m_pImageData);
		m_pImageData = NULL;
	}

	CDialog::OnDestroy();
}
